<?php


/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * MintHCM is a Human Capital Management software based on SuiteCRM developed by MintHCM, 
 * Copyright (C) 2018-2023 MintHCM
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by SugarCRM" 
 * logo and "Supercharged by SuiteCRM" logo and "Reinvented by MintHCM" logo. 
 * If the display of the logos is not reasonably feasible for technical reasons, the 
 * Appropriate Legal Notices must display the words "Powered by SugarCRM" and 
 * "Supercharged by SuiteCRM" and "Reinvented by MintHCM".
 */

/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/06_Customer_Center/10_Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$dictionary['Recruitments'] = array(
   'table' => 'recruitments',
   'audited' => true,
   'activity_enabled' => false,
   'duplicate_merge' => true,
   'fields' => array(
      'name' => array(
         'name' => 'name',
         'vname' => 'LBL_NAME',
         'type' => 'name',
         'dbType' => 'varchar',
         'len' => '255',
         'unified_search' => true,
         'full_text_search' => array(
            'boost' => '3',
            'enabled' => true,
         ),
         'required' => false,
         'importable' => 'required',
         'duplicate_merge' => 'enabled',
         'merge_filter' => 'selected',
         'duplicate_on_record_copy' => 'always',
         'massupdate' => false,
         'no_default' => false,
         'comments' => '',
         'readonly' => true,
         'help' => '',
         'duplicate_merge_dom_value' => '3',
         'audited' => true,
         'reportable' => true,
         'calculated' => true,
         'enforced' => true,
         'size' => '20',
      ),
      'end_date' => array(
         'name' => 'end_date',
         'label' => 'LBL_END_DATE',
         'vname' => 'LBL_END_DATE',
         'comments' => '',
         'help' => '',
         'type' => 'date',
         'audited' => true,
         'max_size' => NULL,
         'require_option' => '0',
         'default_value' => '',
         'deleted' => '0',
         'massupdate' => true,
         'duplicate_merge' => '1',
         'reportable' => '1',
         'importable' => 'true',
         'enforced' => '',
         'dependency' => '',
         'enable_range_search' => true,
         'options' => 'date_range_search_dom',
      ),
      'announcement' => array(
         'name' => 'announcement',
         'label' => 'LBL_ANNOUNCEMENT',
         'vname' => 'LBL_ANNOUNCEMENT',
         'comments' => '',
         'help' => '',
         'type' => 'url',
         'max_size' => '255',
         'require_option' => '0',
         'default_value' => '',
         'deleted' => '0',
         'importable' => false,
         'reportable' => false,
         'studio' => false,
         'audited' => false,
         'massupdate' => false,
         'duplicate_merge' => false,
         'ext1' => '',
         'ext2' => '',
         'ext3' => '',
         'ext4' => '_self',
         'full_text_search' => array(
            'boost' => '0',
            'enabled' => false,
         ),
         'dependency' => '',
      ),
      'project_status' => array(
         'required' => false,
         'name' => 'project_status',
         'vname' => 'LBL_PROJECT_STATUS',
         'massupdate' => false,
         'default' => 'for_approval',
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'type' => 'ColoredEnum',
         'dbType' => 'varchar',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'calculated' => false,
         'len' => 100,
         'size' => '20',
         'options' => 'project_status_list',
         'options_colors' => 'project_status_list_colored',
         'studio' => 'visible',
         'dependency' => false,
      ),
      'start_date' => array(
         'name' => 'start_date',
         'label' => 'LBL_START_DATE',
         'vname' => 'LBL_START_DATE',
         'comments' => '',
         'help' => '',
         'type' => 'date',
         'max_size' => NULL,
         'require_option' => '0',
         'default_value' => '',
         'deleted' => '0',
         'massupdate' => true,
         'duplicate_merge' => '1',
         'reportable' => '1',
         'importable' => 'true',
         'enforced' => '',
         'dependency' => '',
         'required' => true,
         'enable_range_search' => true,
         'options' => 'date_range_search_dom',
      ),
      'start_work_date' => array(
         'name' => 'start_work_date',
         'label' => 'LBL_START_WORK_DATE',
         'vname' => 'LBL_START_WORK_DATE',
         'comments' => '',
         'help' => '',
         'type' => 'date',
         'max_size' => NULL,
         'require_option' => '0',
         'default_value' => '',
         'deleted' => '0',
         'massupdate' => true,
         'audited' => true,
         'duplicate_merge' => '1',
         'reportable' => '1',
         'importable' => 'true',
         'enforced' => '',
         'dependency' => '',
         'enable_range_search' => true,
         'options' => 'date_range_search_dom',
      ),
      'vacancy' => array(
         'name' => 'vacancy',
         'label' => 'LBL_VACANCY',
         'vname' => 'LBL_VACANCY',
         'comments' => '',
         'help' => '',
         'type' => 'int',
         'max_size' => '255',
         'require_option' => '0',
         'default_value' => '',
         'deleted' => '0',
         'audited' => true,
         'massupdate' => false,
         'duplicate_merge' => '1',
         'reportable' => '1',
         'importable' => 'true',
         'full_text_search' => array(
            'boost' => '0',
            'enabled' => false,
         ),
         'enforced' => '',
         'dependency' => 'not(equal($recruitment_type,"continuous"))',
         'vt_dependency' => 'not(equals($recruitment_type,\'continuous\'))',
         'enable_range_search' => true,
         'options' => 'numeric_range_search_dom',
      ),
      'employees_number' => array(
         'name' => 'employees_number',
         'label' => 'LBL_EMPLOYEES_NUMBER',
         'vname' => 'LBL_EMPLOYEES_NUMBER',
         'type' => 'int',
         'max_size' => '255',
         'require_option' => '0',
         'default_value' => '',
         'deleted' => '0',
         'audited' => true,
         'massupdate' => false,
         'duplicate_merge' => '1',
         'reportable' => '1',
         'importable' => 'true',
         'readonly' => true,
         'enable_range_search' => true,
         'options' => 'numeric_range_search_dom',
      ),
      "candidatures" => array(
         'name' => 'candidatures',
         'type' => 'link',
         'relationship' => 'candidatures_recruitments',
         'source' => 'non-db',
         'module' => 'Candidatures',
         'bean_name' => 'Candidatures',
         'vname' => 'LBL_CANDIDATURES_RECRUITMENTS_FROM_RECRUITMENTS_TITLE',
         'id_name' => 'recruitment_id',
         'link-type' => 'many',
         'side' => 'left',
      ),
      "candidatures_end" => array(
         'name' => 'candidatures_end',
         'type' => 'link',
         'relationship' => 'candidatures_recruitments_end',
         'source' => 'non-db',
         'module' => 'Candidatures',
         'bean_name' => 'Candidatures',
         'vname' => 'LBL_CANDIDATURES_RECRUITMENTS_END_FROM_RECRUITMENTS_TITLE',
         'id_name' => 'recruitment_end_id',
         'link-type' => 'many',
         'side' => 'left',
      ),
      "positions" => array(
         'name' => 'positions',
         'type' => 'link',
         'relationship' => 'recruitments_positions',
         'source' => 'non-db',
         'module' => 'Positions',
         'bean_name' => 'Positions',
         'side' => 'right',
         'vname' => 'LBL_RECRUITMENTS_POSITIONS_FROM_RECRUITMENTS_TITLE',
         'id_name' => 'position_id',
         'link-type' => 'one',
      ),
      "position_name" => array(
         'name' => 'position_name',
         'type' => 'relate',
         'source' => 'non-db',
         'vname' => 'LBL_RECRUITMENTS_POSITIONS_FROM_POSITIONS_TITLE',
         'save' => true,
         'id_name' => 'position_id',
         'link' => 'positions',
         'table' => 'positions',
         'module' => 'Positions',
         'rname' => 'name',
         'required' => true,
      ),
      "position_id" => array(
         'name' => 'position_id',
         'type' => 'id',
         'relationship' => 'recruitments_positions',
         'vname' => 'LBL_RECRUITMENTS_POSITIONS_FROM_RECRUITMENTS_TITLE_ID',
         'reportable' => false,
         'rname' => 'id',
         'isnull' => 'true',
         'dbType' => 'id'
      ),
      "calls" => array(
         'name' => 'calls',
         'type' => 'link',
         'relationship' => 'recruitments_calls',
         'source' => 'non-db',
         'module' => 'Calls',
         'bean_name' => 'Call',
         'vname' => 'LBL_RECRUITMENTS_ACTIVITIES_CALLS_FROM_CALLS_TITLE',
      ),
      "meetings" => array(
         'name' => 'meetings',
         'type' => 'link',
         'relationship' => 'recruitments_meetings',
         'source' => 'non-db',
         'module' => 'Meetings',
         'bean_name' => 'Meeting',
         'vname' => 'LBL_RECRUITMENTS_ACTIVITIES_MEETINGS_FROM_MEETINGS_TITLE',
      ),
      "notes" => array(
         'name' => 'notes',
         'type' => 'link',
         'relationship' => 'recruitments_notes',
         'source' => 'non-db',
         'module' => 'Notes',
         'bean_name' => 'Note',
         'vname' => 'LBL_RECRUITMENTS_ACTIVITIES_NOTES_FROM_NOTES_TITLE',
      ),
      "tasks" => array(
         'name' => 'tasks',
         'type' => 'link',
         'relationship' => 'recruitments_tasks',
         'source' => 'non-db',
         'module' => 'Tasks',
         'bean_name' => 'Task',
         'vname' => 'LBL_RECRUITMENTS_ACTIVITIES_TASKS_FROM_TASKS_TITLE',
      ),
      "emails" => array(
         'name' => 'emails',
         'type' => 'link',
         'relationship' => 'recruitments_emails',
         'source' => 'non-db',
         'module' => 'Emails',
         'bean_name' => 'Email',
         'vname' => 'LBL_RECRUITMENTS_ACTIVITIES_EMAILS_FROM_EMAILS_TITLE',
      ),
      'version' => array(
         'name' => 'version',
         'vname' => 'LBL_VERSION',
         'type' => 'varchar',
         'importable' => false,
         'reportable' => false,
         'studio' => false,
         'audited' => false,
         'massupdate' => false,
         'duplicate_merge' => false,
      ),
      'recruitment_channels' => array(
         'required' => false,
         'name' => 'recruitment_channels',
         'vname' => 'LBL_RECRUITMENT_CHANNELS',
         'type' => 'multienum',
         'massupdate' => false,
         'default' => '',
         'no_default' => false,
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => false,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'calculated' => false,
         'len' => 100,
         'size' => '20',
         'options' => 'source_list',
         'studio' => 'visible',
         'dependency' => false,
         'isMultiSelect' => true,
      ),
      'recruitment_type' => array(
         'required' => true,
         'name' => 'recruitment_type',
         'vname' => 'LBL_RECRUITMENT_TYPE',
         'type' => 'enum',
         'massupdate' => false,
         'default' => '',
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'calculated' => false,
         'len' => 100,
         'size' => '20',
         'options' => 'recruitment_type_list',
         'studio' => 'visible',
         'dependency' => false,
      ),
      'salary_from' => array(
         'required' => true,
         'name' => 'salary_from',
         'vname' => 'LBL_SALARY_FROM',
         'type' => 'currency',
         'massupdate' => false,
         'default' => 0,
         'no_default' => false,
         'importable' => false,
         'duplicate_merge' => 'enabled',
         'duplicate_merge_dom_value' => '1',
         'audited' => true,
         'reportable' => false,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => 26,
         'size' => '20',
         'enable_range_search' => false,
         'precision' => 6,
         'related_fields' => array(
            'currency_id',
         ),
         'enforced' => false,
         'calculated' => false,
         'formula' => '',
      ),
      'salary_from_usdollar' => array(
         'required' => false,
         'name' => 'salary_from_usdollar',
         'vname' => 'LBL_SALARY_FROM_USDOLLAR',
         'type' => 'currency',
         'massupdate' => false,
         'default' => 0,
         'no_default' => false,
         'importable' => false,
         'duplicate_merge' => 'disabled',
         'audited' => false,
         'reportable' => false,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => 26,
         'size' => '20',
         'enable_range_search' => false,
         'precision' => 6,
         'related_fields' => array(
            'currency_id',
         ),
         'enforced' => false,
         'calculated' => false,
         'formula' => '',
      ),
      'salary_to' => array(
         'required' => true,
         'name' => 'salary_to',
         'vname' => 'LBL_SALARY_TO',
         'type' => 'currency',
         'massupdate' => false,
         'default' => 0,
         'no_default' => false,
         'importable' => false,
         'duplicate_merge' => 'enabled',
         'duplicate_merge_dom_value' => '1',
         'audited' => true,
         'reportable' => false,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => 26,
         'size' => '20',
         'enable_range_search' => false,
         'precision' => 6,
         'related_fields' => array(
            'currency_id',
         ),
         'enforced' => false,
         'calculated' => false,
         'formula' => '',
      ),
      'salary_to_usdollar' => array(
         'required' => false,
         'name' => 'salary_to_usdollar',
         'vname' => 'LBL_SALARY_TO_USDOLLAR',
         'type' => 'currency',
         'massupdate' => false,
         'default' => 0,
         'no_default' => false,
         'importable' => false,
         'duplicate_merge' => 'disabled',
         'audited' => false,
         'reportable' => false,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => 26,
         'size' => '20',
         'enable_range_search' => false,
         'precision' => 6,
         'related_fields' => array(
            'currency_id',
         ),
         'enforced' => false,
         'calculated' => false,
         'formula' => '',
      ),
      'currency_id' =>
      array(
         'name' => 'currency_id',
         'type' => 'id',
         'group' => 'currency_id',
         'vname' => 'LBL_CURRENCY',
         'function' => array( 'name' => 'getCurrencyDropDown', 'returns' => 'html' ),
         'reportable' => false,
         'comment' => 'Currency used for display purposes'
      ),
      'currency_name' =>
      array(
         'name' => 'currency_name',
         'rname' => 'name',
         'id_name' => 'currency_id',
         'vname' => 'LBL_CURRENCY_NAME',
         'type' => 'relate',
         'isnull' => 'true',
         'table' => 'currencies',
         'module' => 'Currencies',
         'source' => 'non-db',
         'function' => array( 'name' => 'getCurrencyNameDropDown', 'returns' => 'html' ),
         'studio' => 'false',
         'duplicate_merge' => 'disabled',
      ),
      'currency_symbol' =>
      array(
         'name' => 'currency_symbol',
         'rname' => 'symbol',
         'id_name' => 'currency_id',
         'vname' => 'LBL_CURRENCY_SYMBOL',
         'type' => 'relate',
         'isnull' => 'true',
         'table' => 'currencies',
         'module' => 'Currencies',
         'source' => 'non-db',
         'function' => array( 'name' => 'getCurrencySymbolDropDown', 'returns' => 'html' ),
         'studio' => 'false',
         'duplicate_merge' => 'disabled',
      ),
   ),
   'relationships' => array(
      'candidatures_recruitments' =>
      array(
         'lhs_module' => 'Recruitments',
         'lhs_table' => 'recruitments',
         'lhs_key' => 'id',
         'rhs_module' => 'Candidatures',
         'rhs_table' => 'candidatures',
         'rhs_key' => 'recruitment_id',
         'relationship_type' => 'one-to-many',
      ),
      'candidatures_recruitments_end' =>
      array(
         'lhs_module' => 'Recruitments',
         'lhs_table' => 'recruitments',
         'lhs_key' => 'id',
         'rhs_module' => 'Candidatures',
         'rhs_table' => 'candidatures',
         'rhs_key' => 'recruitment_end_id',
         'relationship_type' => 'one-to-many',
      ),
      'recruitments_calls' =>
      array(
         'lhs_module' => 'Recruitments',
         'lhs_table' => 'recruitments',
         'lhs_key' => 'id',
         'rhs_module' => 'Calls',
         'rhs_table' => 'calls',
         'relationship_role_column_value' => 'Recruitments',
         'rhs_key' => 'parent_id',
         'relationship_type' => 'one-to-many',
         'relationship_role_column' => 'parent_type',
      ),
      'recruitments_meetings' =>
      array(
         'lhs_module' => 'Recruitments',
         'lhs_table' => 'recruitments',
         'lhs_key' => 'id',
         'rhs_module' => 'Meetings',
         'rhs_table' => 'meetings',
         'relationship_role_column_value' => 'Recruitments',
         'rhs_key' => 'parent_id',
         'relationship_type' => 'one-to-many',
         'relationship_role_column' => 'parent_type',
      ),
      'recruitments_notes' =>
      array(
         'lhs_module' => 'Recruitments',
         'lhs_table' => 'recruitments',
         'lhs_key' => 'id',
         'rhs_module' => 'Notes',
         'rhs_table' => 'notes',
         'relationship_role_column_value' => 'Recruitments',
         'rhs_key' => 'parent_id',
         'relationship_type' => 'one-to-many',
         'relationship_role_column' => 'parent_type',
      ),
      'recruitments_tasks' =>
      array(
         'lhs_module' => 'Recruitments',
         'lhs_table' => 'recruitments',
         'lhs_key' => 'id',
         'rhs_module' => 'Tasks',
         'rhs_table' => 'tasks',
         'relationship_role_column_value' => 'Recruitments',
         'rhs_key' => 'parent_id',
         'relationship_type' => 'one-to-many',
         'relationship_role_column' => 'parent_type',
      ),      
   ),
   'optimistic_locking' => true,
   'unified_search' => true,
);

if ( !class_exists('VardefManager') ) {
   require_once 'include/SugarObjects/VardefManager.php';
}
VardefManager::createVardef('Recruitments', 'Recruitments', array( 'basic', 'assignable', 'security_groups' ));
