<?php

$dictionary['Files'] = array(
    'table' => 'files',
    'audited' => true,
    'inline_edit' => false,
    'duplicate_merge' => true,
    'fields' => array(
        'parent_id' => array(
            'name' => 'parent_id',
            'type' => 'id',
            'group' => 'parent_name',
            'vname' => 'LBL_PARENT_ID',
            'label' => 'LBL_PARENT_ID',
            'importable' => 'true',
            'reportable' => true,
            'audited' => false,
        ),
        'parent_type' => array(
            'name' => 'parent_type',
            'vname' => 'LBL_PARENT_TYPE',
            'label' => 'LBL_PARENT_TYPE',
            'type' => 'parent_type',
            'dbType' => 'varchar',
            'group' => 'parent_name',
            'options' => 'parent_type_display_for_files',
            'importable' => 'true',
            'reportable' => true,
            'audited' => true,
        ),
        'parent_name' => array(
            'name' => 'parent_name',
            'parent_type' => 'parent_type_display_for_files',
            'type_name' => 'parent_type',
            'id_name' => 'parent_id',
            'vname' => 'LBL_LIST_RELATED_TO',
            'label' => 'LBL_LIST_RELATED_TO',
            'type' => 'parent',
            'group' => 'parent_name',
            'source' => 'non-db',
            'options' => 'parent_type_display_for_files',
            'importable' => 'true',
            'reportable' => true,
            'audited' => true,
            'massupdate' => false,
            'sortable' => false,
        ),
        'candidature' => array(
            'name' => 'candidature',
            'type' => 'link',
            'relationship' => 'candidatures_files',
            'source' => 'non-db',
            'module' => 'Candidatures',
            'bean_name' => 'Candidature',
            'vname' => 'LBL_CANDIDATURE',
            'label' => 'LBL_CANDIDATURE',
        ),
        'candidate' => array(
            'name' => 'candidate',
            'type' => 'link',
            'relationship' => 'candidates_files',
            'source' => 'non-db',
            'module' => 'Candidates',
            'bean_name' => 'Candidate',
            'vname' => 'LBL_CANDIDATE',
            'label' => 'LBL_CANDIDATE',
        ),
        'resource' => array(
            'name' => 'resource',
            'type' => 'link',
            'relationship' => 'resources_files',
            'source' => 'non-db',
            'module' => 'Resources',
            'bean_name' => 'Resource',
            'vname' => 'LBL_RESOURCE',
            'label' => 'LBL_RESOURCE',
        ),
        'position' => array(
            'name' => 'position',
            'type' => 'link',
            'relationship' => 'positions_files',
            'source' => 'non-db',
            'module' => 'Positions',
            'bean_name' => 'Position',
            'vname' => 'LBL_POSITION',
            'label' => 'LBL_POSITION',
        ),
        'workplace' => array(
            'name' => 'workplace',
            'type' => 'link',
            'relationship' => 'workplaces_files',
            'source' => 'non-db',
            'module' => 'Workplaces',
            'bean_name' => 'Workplace',
            'vname' => 'LBL_WORKPLACE',
            'label' => 'LBL_WORKPLACE',
        ),
        'training' => array(
            'name' => 'training',
            'type' => 'link',
            'relationship' => 'trainings_files',
            'source' => 'non-db',
            'module' => 'Traininges',
            'bean_name' => 'Traininge',
            'vname' => 'LBL_TRAINING',
            'label' => 'LBL_TRAINING',
        ),
        'idea' => array(
            'name' => 'idea',
            'type' => 'link',
            'relationship' => 'ideas_files',
            'source' => 'non-db',
            'module' => 'Ideas',
            'bean_name' => 'Idea',
            'vname' => 'LBL_IDEA',
            'label' => 'LBL_IDEA',
        ),
        'dropzone' => array(
            'name' => 'dropzone',
            'vname' => 'LBL_PHOTOS',
            'label' => 'LBL_PHOTOS',
            'type' => 'Dropzone',
            'source' => 'non-db',
            'importable' => false,
            'reportable' => false,
            'audited' => false,
            'size' => 30,
        ),
    ),
    'relationships' => array(
        'candidatures_files' => array(
            'lhs_module' => 'Candidatures',
            'lhs_table' => 'candidatures',
            'lhs_key' => 'id',
            'rhs_module' => 'Files',
            'rhs_table' => 'files',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Candidatures',
        ),
        'candidates_files' => array(
            'lhs_module' => 'Candidates',
            'lhs_table' => 'candidates',
            'lhs_key' => 'id',
            'rhs_module' => 'Files',
            'rhs_table' => 'files',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Candidates',
        ),
        'resources_files' => array(
            'lhs_module' => 'Resources',
            'lhs_table' => 'resources',
            'lhs_key' => 'id',
            'rhs_module' => 'Files',
            'rhs_table' => 'files',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Resources',
        ),
        'positions_files' => array(
            'lhs_module' => 'Positions',
            'lhs_table' => 'positions',
            'lhs_key' => 'id',
            'rhs_module' => 'Files',
            'rhs_table' => 'files',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Positions',
        ),
        'workplaces_files' => array(
            'lhs_module' => 'Workplaces',
            'lhs_table' => 'workplaces',
            'lhs_key' => 'id',
            'rhs_module' => 'Files',
            'rhs_table' => 'files',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Workplaces',
        ),
        'trainings_files' => array(
            'lhs_module' => 'Trainings',
            'lhs_table' => 'trainings',
            'lhs_key' => 'id',
            'rhs_module' => 'Files',
            'rhs_table' => 'files',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Trainings',
        ),
        'ideas_files' => array(
            'lhs_module' => 'Ideas',
            'lhs_table' => 'ideas',
            'lhs_key' => 'id',
            'rhs_module' => 'Files',
            'rhs_table' => 'files',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Ideas',
        ),
    ),
    'indices' => array(        
    ),
    'optimistic_locking' => true,
    'unified_search' => true,
);
if (!class_exists('VardefManager')) {
    require_once 'include/SugarObjects/VardefManager.php';
}
VardefManager::createVardef('Files', 'Files', array('basic', 'security_groups', 'assignable', 'file'));
