<?php

$dictionary['Comments'] = array(
    'table' => 'comments',
    'audited' => false,
    'inline_edit' => false,
    'duplicate_merge' => false,
    'fields' => array(
        'reply_to' => array(
            'name' => 'reply_to',
            'type' => 'link',
            'relationship' => 'comments_replies',
            'source' => 'non-db',
            'module' => 'Comments',
            'bean_name' => 'Comments',
            'vname' => 'LBL_REPLY_TO',
            'label' => 'LBL_REPLY_TO',
            'link_type' => 'one',
            'side' => 'right',
        ),
        'replies' => array(
            'name' => 'comments',
            'type' => 'link',
            'relationship' => 'comments_replies',
            'source' => 'non-db',
            'module' => 'Comments',
            'bean_name' => 'Comments',
            'vname' => 'LBL_REPLIES',
            'label' => 'LBL_REPLIES',
            'id_link' => 'reply_to_id',
        ),
        'reply_to_id' => array(
            'name' => 'reply_to_id',
            'type' => 'id',
            'vname' => 'LBL_REPLY_TO_ID',
            'label' => 'LBL_REPLY_TO_ID',
            'audited' => true,
            'importable' => 'true',
            'reportable' => true,
        ),
        'reply_to_name' => array(
            'name' => 'reply_to_name',
            'type' => 'relate',
            'source' => 'non-db',
            'vname' => 'LBL_REPLY_TO_NAME',
            'label' => 'LBL_REPLY_TO_NAME',
            'id_name' => 'reply_to_id',
            'link' => 'reply_to',
            'join_name' => 'reply_to',
            'module' => 'Comments',
            'table' => 'comments',
            'rname' => 'name',
            'importable' => 'true',
            'reportable' => true,
            'audited' => true,
        ),
        'news' => array(
            'name' => 'news',
            'type' => 'link',
            'relationship' => 'news_comments',
            'module' => 'News',
            'bean_name' => 'News',
            'source' => 'non-db',
            'vname' => 'LBL_NEWS',
        ),
        'parent_type' => array(
            'name' => 'parent_type',
            'vname' => 'LBL_PARENT_TYPE',
            'type' => 'parent_type',
            'dbType' => 'varchar',
            'required' => false,
            'group' => 'parent_name',
            'options' => 'parent_type_display_comments',
            'len' => 255,
        ),
        'parent_name' => array(
            'name' => 'parent_name',
            'parent_type' => 'record_type_display_comments',
            'type_name' => 'parent_type',
            'id_name' => 'parent_id',
            'vname' => 'LBL_LIST_RELATED_TO',
            'type' => 'parent',
            'group' => 'parent_name',
            'source' => 'non-db',
            'options' => 'parent_type_display_comments',
        ),
        'parent_id' => array(
            'name' => 'parent_id',
            'vname' => 'LBL_LIST_RELATED_TO_ID',
            'type' => 'id',
            'group' => 'parent_name',
            'reportable' => false,
        ),
        'pinned' => array(
            'name' => 'pinned',
            'vname' => 'LBL_PINNED',
            'label' => 'LBL_PINNED',
            'type' => 'bool',
            'reportable' => false,
            'audited' => false,
            'importable' => 'false',
        ),
        'removed' => array(
            'name' => 'removed',
            'vname' => 'LBL_REMOVED',
            'label' => 'LBL_REMOVED',
            'type' => 'bool',
            'reportable' => false,
            'audited' => true,
            'importable' => 'false',
        ),
        'date_edited' => array(
            'name' => 'date_edited',
            'vname' => 'LBL_DATE_EDITED',
            'label' => 'LBL_DATE_EDITED',
            'type' => 'datetime',
            'reportable' => false,
            'audited' => false,
            'importable' => 'false',
        ),
    ),
    'relationships' => array(
        'comments_replies' => array(
            'lhs_module' => 'Comments',
            'lhs_table' => 'comments',
            'lhs_key' => 'id',
            'rhs_module' => 'Comments',
            'rhs_table' => 'comments',
            'rhs_key' => 'reply_to_id',
            'relationship_type' => 'one-to-many',
        ),
    ),
    'optimistic_locking' => true,
    'unified_search' => true,
);
if (!class_exists('VardefManager')) {
    require_once 'include/SugarObjects/VardefManager.php';
}
VardefManager::createVardef('Comments', 'Comments', array('basic', 'assignable'));
