<?php

/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * MintHCM is a Human Capital Management software based on SuiteCRM developed by MintHCM,
 * Copyright (C) 2018-2023 MintHCM
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by SugarCRM"
 * logo and "Supercharged by SuiteCRM" logo and "Reinvented by MintHCM" logo.
 * If the display of the logos is not reasonably feasible for technical reasons, the
 * Appropriate Legal Notices must display the words "Powered by SugarCRM" and
 * "Supercharged by SuiteCRM" and "Reinvented by MintHCM".
 */
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/06_Customer_Center/10_Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$dictionary['Candidatures'] = array(
    'table' => 'candidatures',
    'audited' => true,
    'activity_enabled' => false,
    'duplicate_merge' => true,
    'full_text_search_meta_field' => 'status',
    'fields' => array(
        'name' => array(
            'name' => 'name',
            'vname' => 'LBL_NAME',
            'type' => 'name',
            'dbType' => 'varchar',
            'len' => '255',
            'unified_search' => true,
            'full_text_search' => array(
                'boost' => '3',
                'enabled' => true,
            ),
            'required' => false,
            'importable' => 'required',
            'duplicate_merge' => 'enabled',
            'merge_filter' => 'selected',
            'duplicate_on_record_copy' => 'always',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'readonly' => true,
            'help' => '',
            'duplicate_merge_dom_value' => '3',
            'audited' => true,
            'reportable' => true,
            'calculated' => false,
            'enforced' => true,
            'size' => '20',
        ),
        'currency_id' => array(
            'name' => 'currency_id',
            'type' => 'id',
            'group' => 'currency_id',
            'vname' => 'LBL_CURRENCY',
            'function' => array('name' => 'getCurrencyDropDown', 'returns' => 'html'),
            'reportable' => false,
            'comment' => 'Currency used for display purposes',
        ),
        'currency_name' => array(
            'name' => 'currency_name',
            'rname' => 'name',
            'id_name' => 'currency_id',
            'vname' => 'LBL_CURRENCY_NAME',
            'type' => 'relate',
            'isnull' => 'true',
            'table' => 'currencies',
            'module' => 'Currencies',
            'source' => 'non-db',
            'function' => array('name' => 'getCurrencyNameDropDown', 'returns' => 'html'),
            'studio' => 'false',
            'duplicate_merge' => 'disabled',
        ),
        'currency_symbol' => array(
            'name' => 'currency_symbol',
            'rname' => 'symbol',
            'id_name' => 'currency_id',
            'vname' => 'LBL_CURRENCY_SYMBOL',
            'type' => 'relate',
            'isnull' => 'true',
            'table' => 'currencies',
            'module' => 'Currencies',
            'source' => 'non-db',
            'function' => array('name' => 'getCurrencySymbolDropDown', 'returns' => 'html'),
            'studio' => 'false',
            'duplicate_merge' => 'disabled',
        ),
        'reason_for_rejection' => array(
            'vt_dependency' => 'equals($status,\'Rejected\')',
            'vt_required' => 'equals($status,\'Rejected\')',
            'name' => 'reason_for_rejection',
            'vname' => 'LBL_REASON_FOR_REJECTION',
            'type' => 'enum',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '1',
            'audited' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => 100,
            'size' => '20',
            'options' => 'reason_for_rejection_list',
            'default' => null,
        ),
        'dg_amount' => array(
            'name' => 'dg_amount',
            'label' => 'LBL_DG_AMOUNT',
            'vname' => 'LBL_DG_AMOUNT',
            'comments' => null,
            'help' => null,
            'type' => 'currency',
            'max_size' => '26',
            'require_option' => '0',
            'default_value' => '0',
            'deleted' => '0',
            'audited' => true,
            'massupdate' => false,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => '',
            'related_fields' => array(
                'currency_id',
            ),
        ),
        'dg_amount_usdollar' => array(
            'name' => 'dg_amount_usdollar',
            'vname' => 'LBL_DG_AMOUNT_USDOLLAR',
            'comments' => null,
            'help' => null,
            'type' => 'currency',
            'max_size' => '26',
            'require_option' => '0',
            'default_value' => '0',
            'deleted' => '0',
            'audited' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => '',
            'related_fields' => array(
                'currency_id',
            ),
        ),
        'gross_amount' => array(
            'name' => 'gross_amount',
            'label' => 'LBL_GROSS_AMOUNT',
            'vname' => 'LBL_GROSS_AMOUNT',
            'comments' => '',
            'help' => '',
            'type' => 'currency',
            'max_size' => '26',
            'require_option' => '0',
            'default_value' => '0',
            'deleted' => '0',
            'audited' => true,
            'massupdate' => false,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => '',
            'related_fields' => array(
                'currency_id',
            ),
        ),
        'gross_amount_usdollar' => array(
            'name' => 'gross_amount_usdollar',
            'vname' => 'LBL_GROSS_AMOUNT_USDOLLAR',
            'comments' => '',
            'help' => '',
            'type' => 'currency',
            'max_size' => '26',
            'require_option' => '0',
            'default_value' => '0',
            'deleted' => '0',
            'audited' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => '',
            'related_fields' => array(
                'currency_id',
            ),
        ),
        'net_amount' => array(
            'name' => 'net_amount',
            'label' => 'LBL_NET_AMOUNT',
            'vname' => 'LBL_NET_AMOUNT',
            'comments' => null,
            'help' => null,
            'type' => 'currency',
            'max_size' => '26',
            'require_option' => '0',
            'default_value' => '0',
            'deleted' => '0',
            'audited' => true,
            'massupdate' => false,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => '',
            'related_fields' => array(
                'currency_id',
            ),
        ),
        'net_amount_usdollar' => array(
            'name' => 'net_amount_usdollar',
            'vname' => 'LBL_NET_AMOUNT_USDOLLAR',
            'comments' => null,
            'help' => null,
            'type' => 'currency',
            'max_size' => '26',
            'require_option' => '0',
            'default_value' => '0',
            'deleted' => '0',
            'audited' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => '',
            'related_fields' => array(
                'currency_id',
            ),
        ),
        'notice' => array(
            'name' => 'notice',
            'label' => 'LBL_NOTICE',
            'vname' => 'LBL_NOTICE',
            'comments' => null,
            'help' => null,
            'type' => 'text',
            'max_size' => null,
            'require_option' => '0',
            'default_value' => null,
            'deleted' => '0',
            'massupdate' => false,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'rows' => 6,
            'cols' => 80,
            'full_text_search' => array(
                'boost' => '0',
                'enabled' => false,
            ),
            'enforced' => '',
            'dependency' => '',
        ),
        'notice_final_expectations' => array(
            'name' => 'notice_final_expectations',
            'label' => 'LBL_NOTICE_FINAL_EXPECTATIONS',
            'vname' => 'LBL_NOTICE_FINAL_EXPECTATIONS',
            'comments' => null,
            'help' => null,
            'type' => 'text',
            'max_size' => null,
            'require_option' => '0',
            'default_value' => null,
            'deleted' => '0',
            'massupdate' => false,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'rows' => 6,
            'cols' => 80,
            'full_text_search' => array(
                'boost' => '0',
                'enabled' => false,
            ),
            'enforced' => '',
            'dependency' => '',
        ),
        'salary_net' => array(
            'name' => 'salary_net',
            'label' => 'LBL_SALARY_NET',
            'vname' => 'LBL_SALARY_NET',
            'comments' => '',
            'help' => '',
            'type' => 'currency',
            'max_size' => '26',
            'require_option' => '0',
            'default_value' => '0',
            'deleted' => '0',
            'audited' => true,
            'massupdate' => false,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => '',
            'related_fields' => array(
                'currency_id',
            ),
        ),
        'salary_net_usdollar' => array(
            'name' => 'salary_net_usdollar',
            'vname' => 'LBL_SALARY_NET_USDOLLAR',
            'comments' => '',
            'help' => '',
            'type' => 'currency',
            'max_size' => '26',
            'require_option' => '0',
            'default_value' => '0',
            'deleted' => '0',
            'audited' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => '',
            'related_fields' => array(
                'currency_id',
            ),
        ),
        'scoring' => array(
            'required' => false,
            'name' => 'scoring',
            'vname' => 'SCORING',
            'type' => 'enum',
            'audited' => true,
            'default' => '',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'massupdate' => false,
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => 100,
            'size' => '20',
            'options' => 'scoring_list',
            'studio' => 'visible',
            'dependency' => false,
        ),
        'source' => array(
            'required' => false,
            'name' => 'source',
            'vname' => 'LBL_SOURCE',
            'type' => 'enum',
            'massupdate' => true,
            'default' => '',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => 100,
            'size' => '20',
            'function' => ['name' => 'getDictionary',
                'additional_params' => 'Candidatures-source',
                'include' => 'include/utils/getDictionary.php'],
            'studio' => 'visible',
            'dependency' => false,
            'required' => true,
        ),
        'start_date' => array(
            'name' => 'start_date',
            'label' => 'LBL_START_DATE',
            'vname' => 'LBL_START_DATE',
            'comments' => null,
            'help' => null,
            'type' => 'date',
            'max_size' => null,
            'require_option' => '1',
            'default_value' => null,
            'deleted' => '0',
            'massupdate' => true,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
        ),
        'work_start' => array(
            'name' => 'work_start',
            'label' => 'LBL_WORK_START',
            'vname' => 'LBL_WORK_START',
            'type' => 'date',
            'require_option' => '1',
            'massupdate' => true,
            'audited' => true,
            'importable' => 'true',
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'dependency' => 'or(equal($status,"Acceptance"),equal($status,"Hired"))',
            'vt_dependency' => 'or(equals($status,\'Acceptance\'),equals($status,\'Hired\'))',
        ),
        'training_date' => array(
            'name' => 'training_date',
            'label' => 'LBL_TRAINING_DATE',
            'vname' => 'LBL_TRAINING_DATE',
            'type' => 'date',
            'require_option' => '1',
            'massupdate' => true,
            'audited' => true,
            'importable' => 'true',
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => 'or(equal($status,"Acceptance"),equal($status,"Hired"))',
            'vt_dependency' => 'or(equals($status,\'Acceptance\'),equals($status,\'Hired\'))',
        ),
        'status' => array(
            'required' => false,
            'name' => 'status',
            'vname' => 'LBL_STATUS',
            'type' => 'ColoredEnum',
            'dbType' => 'varchar',
            'massupdate' => true,
            'default' => 'New',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => 100,
            'size' => '20',
            'options' => 'status_list',
            'options_colors' => 'status_list_colored',
            'studio' => 'visible',
        ),
        'status_information' => array(
            'name' => 'status_information',
            'label' => 'LBL_STATUS_INFORMATION',
            'vname' => 'LBL_STATUS_INFORMATION',
            'comments' => '',
            'help' => '',
            'type' => 'text',
            'max_size' => null,
            'require_option' => '0',
            'default_value' => '',
            'deleted' => '0',
            'massupdate' => false,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'rows' => 6,
            'cols' => 80,
            'full_text_search' => array(
                'boost' => '0',
                'enabled' => false,
            ),
            'enforced' => '',
            'dependency' => '',
        ),
        'task_grade' => array(
            'required' => false,
            'name' => 'task_grade',
            'vname' => 'LBL_TASK_GRADE',
            'type' => 'enum',
            'massupdate' => false,
            'default' => '',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => 100,
            'size' => '20',
            'options' => 'scoring_list',
            'studio' => 'visible',
            'dependency' => false,
        ),
        'to_decision' => array(
            'name' => 'to_decision',
            'label' => 'LBL_TO_DECISION',
            'vname' => 'LBL_TO_DECISION',
            'comments' => '',
            'help' => '',
            'type' => 'bool',
            'max_size' => '255',
            'require_option' => '0',
            'default_value' => '0',
            'deleted' => '0',
            'massupdate' => true,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'enforced' => '',
            'dependency' => '',
        ),
        'final_employment_form' => array(
            'required' => false,
            'name' => 'final_employment_form',
            'vname' => 'LBL_FINAL_EMPLOYMENT_FORM',
            'type' => 'enum',
            'massupdate' => false,
            'default' => '',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => 100,
            'size' => '20',
            'options' => 'employment_form_list',
            'studio' => 'visible',
            'dependency' => false,
        ),
        'employment_form' => array(
            'required' => false,
            'name' => 'employment_form',
            'vname' => 'LBL_EMPLOYMENT_FORM',
            'type' => 'multienum',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'false',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'options' => 'employment_form_list',
            'studio' => 'visible',
            'isMultiSelect' => true,
        ),
        'entry_interview' => array(
            'name' => 'entry_interview',
            'label' => 'LBL_ENTRY_INTERVIEW',
            'vname' => 'LBL_ENTRY_INTERVIEW',
            'comments' => null,
            'help' => null,
            'type' => 'text',
            'max_size' => null,
            'require_option' => '0',
            'default_value' => null,
            'deleted' => '0',
            'massupdate' => false,
            'duplicate_merge' => '1',
            'reportable' => '1',
            'importable' => 'true',
            'rows' => 6,
            'cols' => 80,
            'full_text_search' => array(
                'boost' => '0',
                'enabled' => false,
            ),
            'enforced' => '',
            'dependency' => '',
        ),
        'parent_id' => array(
            'name' => 'parent_id',
            'type' => 'id',
            'group' => 'parent_name',
            'vname' => 'LBL_PARENT_ID',
            'label' => 'LBL_PARENT_ID',
            'importable' => 'true',
            'reportable' => true,
            'audited' => false,
        ),
        'parent_type' => array(
            'name' => 'parent_type',
            'vname' => 'LBL_PARENT_TYPE',
            'label' => 'LBL_PARENT_TYPE',
            'type' => 'parent_type',
            'dbType' => 'varchar',
            'group' => 'parent_name',
            'options' => 'parent_type_display_for_candidatures',
            'importable' => 'true',
            'reportable' => true,
            'audited' => true,
        ),
        'parent_name' => array(
            'name' => 'parent_name',
            'parent_type' => 'parent_type_display_for_candidatures',
            'type_name' => 'parent_type',
            'id_name' => 'parent_id',
            'vname' => 'LBL_LIST_RELATED_TO',
            'label' => 'LBL_LIST_RELATED_TO',
            'type' => 'parent',
            'group' => 'parent_name',
            'source' => 'non-db',
            'options' => 'parent_type_display_for_candidatures',
            'importable' => 'true',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'massupdate' => false,
            'sortable' => false,
        ),
        'candidate' => array(
            'name' => 'candidate',
            'type' => 'link',
            'relationship' => 'candidate_candidatures',
            'source' => 'non-db',
            'module' => 'Candidates',
            'bean_name' => 'Candidates',
            'vname' => 'LBL_CANDIDATE',
            'label' => 'LBL_CANDIDATE',
        ),
        'employee' => array(
            'name' => 'employee',
            'type' => 'link',
            'relationship' => 'employee_candidatures',
            'source' => 'non-db',
            'module' => 'Employees',
            'bean_name' => 'Employee',
            'vname' => 'LBL_EMPLOYEE',
            'label' => 'LBL_EMPLOYEE',
        ),
        "recruitments" => array(
            'name' => 'recruitments',
            'type' => 'link',
            'relationship' => 'candidatures_recruitments',
            'source' => 'non-db',
            'module' => 'Recruitments',
            'bean_name' => 'Recruitments',
            'side' => 'right',
            'vname' => 'LBL_CANDIDATURES_RECRUITMENTS_FROM_CANDIDATURES_TITLE',
            'id_name' => 'recruitment_id',
            'link-type' => 'one',
        ),
        "recruitment_name" => array(
            'required' => true,
            'name' => 'recruitment_name',
            'type' => 'relate',
            'source' => 'non-db',
            'vname' => 'LBL_CANDIDATURES_RECRUITMENTS_FROM_RECRUITMENTS_TITLE',
            'id_name' => 'recruitment_id',
            'link' => 'recruitments',
            'table' => 'recruitments',
            'module' => 'Recruitments',
            'rname' => 'name',
        ),
        "recruitment_id" => array(
            'name' => 'recruitment_id',
            'type' => 'id',
            'relationship' => 'candidatures_recruitments',
            'vname' => 'LBL_CANDIDATURES_RECRUITMENTS_FROM_CANDIDATURES_TITLE_ID',
            'reportable' => false,
            'rname' => 'id',
            'isnull' => 'true',
            'dbType' => 'id',
        ),
        "recruitments_end" => array(
            'name' => 'recruitments_end',
            'type' => 'link',
            'relationship' => 'candidatures_recruitments_end',
            'source' => 'non-db',
            'module' => 'Recruitments',
            'bean_name' => 'Recruitments',
            'side' => 'right',
            'vname' => 'LBL_CANDIDATURES_RECRUITMENTS_END_FROM_CANDIDATURES_TITLE',
            'id_name' => 'recruitment_end_id',
            'link-type' => 'one',
        ),
        "recruitment_end_name" => array(
            'required' => false,
            'name' => 'recruitment_end_name',
            'type' => 'relate',
            'source' => 'non-db',
            'vname' => 'LBL_CANDIDATURES_RECRUITMENTS_END_FROM_RECRUITMENTS_TITLE',
            'id_name' => 'recruitment_end_id',
            'link' => 'recruitments_end',
            'table' => 'recruitments',
            'module' => 'Recruitments',
            'rname' => 'name',
        ),
        "recruitment_end_id" => array(
            'name' => 'recruitment_end_id',
            'type' => 'id',
            'relationship' => 'candidatures_recruitments_end',
            'vname' => 'LBL_CANDIDATURES_RECRUITMENTS_END_FROM_CANDIDATURES_TITLE_ID',
            'reportable' => false,
            'rname' => 'id',
            'isnull' => 'true',
            'dbType' => 'id',
        ),
        "calls" => array(
            'name' => 'calls',
            'type' => 'link',
            'relationship' => 'candidatures_calls',
            'source' => 'non-db',
            'module' => 'Calls',
            'bean_name' => 'Call',
            'vname' => 'LBL_CALLS_TITLE',
        ),
        "meetings" => array(
            'name' => 'meetings',
            'type' => 'link',
            'relationship' => 'candidatures_meetings',
            'source' => 'non-db',
            'module' => 'Meetings',
            'bean_name' => 'Meeting',
            'vname' => 'LBL_MEETINGS_TITLE',
        ),
        "notes" => array(
            'name' => 'notes',
            'type' => 'link',
            'relationship' => 'candidatures_notes',
            'source' => 'non-db',
            'module' => 'Notes',
            'bean_name' => 'Note',
            'vname' => 'LBL_NOTES_TITLE',
        ),
        "tasks" => array(
            'name' => 'tasks',
            'type' => 'link',
            'relationship' => 'candidatures_tasks',
            'source' => 'non-db',
            'module' => 'Tasks',
            'bean_name' => 'Task',
            'vname' => 'LBL_TASKS_TITLE',
        ),
        "emails" => array(
            'name' => 'emails',
            'type' => 'link',
            'relationship' => 'candidatures_emails',
            'source' => 'non-db',
            'module' => 'Emails',
            'bean_name' => 'Email',
            'vname' => 'LBL_EMAILS_TITLE',
        ),
        "appraisals" => array(
            'name' => 'appraisals',
            'type' => 'link',
            'relationship' => 'candidatures_appraisals',
            'source' => 'non-db',
            'module' => 'Appraisals',
            'bean_name' => 'Appraisals',
            'side' => 'right',
            'vname' => 'LBL_CANDIDATURES_APPRAISALS',
        ),
        'documents' => array(
            'name' => 'documents',
            'type' => 'link',
            'relationship' => 'documents_candidatures',
            'source' => 'non-db',
            'vname' => 'LBL_DOCUMENTS',
        ),
        'files' => array(
            'name' => 'files',
            'type' => 'link',
            'relationship' => 'candidatures_files',
            'source' => 'non-db',
            'module' => 'Files',
            'bean_name' => 'Files',
            'vname' => 'LBL_FILES',
            'label' => 'LBL_FILES',
        ),
    ),
    'relationships' => array(
        'candidate_candidatures' => array(
            'lhs_module' => 'Candidates',
            'lhs_table' => 'candidates',
            'lhs_key' => 'id',
            'rhs_module' => 'Candidatures',
            'rhs_table' => 'candidatures',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Candidates',
        ),
        'employee_candidatures' => array(
            'lhs_module' => 'Employees',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Candidatures',
            'rhs_table' => 'candidatures',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Employees',
        ),
        'candidatures_calls' => array(
            'lhs_module' => 'Candidatures',
            'lhs_table' => 'candidatures',
            'lhs_key' => 'id',
            'rhs_module' => 'Calls',
            'rhs_table' => 'calls',
            'relationship_role_column_value' => 'Candidatures',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
        ),
        'candidatures_meetings' => array(
            'lhs_module' => 'Candidatures',
            'lhs_table' => 'candidatures',
            'lhs_key' => 'id',
            'rhs_module' => 'Meetings',
            'rhs_table' => 'meetings',
            'relationship_role_column_value' => 'Candidatures',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
        ),
        'candidatures_notes' => array(
            'lhs_module' => 'Candidatures',
            'lhs_table' => 'candidatures',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'relationship_role_column_value' => 'candidatures',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
        ),
        'candidatures_tasks' => array(
            'lhs_module' => 'Candidatures',
            'lhs_table' => 'candidatures',
            'lhs_key' => 'id',
            'rhs_module' => 'Tasks',
            'rhs_table' => 'tasks',
            'relationship_role_column_value' => 'Candidatures',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
        ),
    ),
    'optimistic_locking' => true,
    'unified_search' => true,
);

if (!class_exists('VardefManager')) {
    require_once 'include/SugarObjects/VardefManager.php';
}
VardefManager::createVardef('Candidatures', 'Candidatures',
    array('basic', 'assignable', 'security_groups', 'employee_related'));
