<?php

if (!defined('sugarEntry') || !sugarEntry) {
    exit('Not A Valid Entry Point');
}

$module_name = 'Candidatures';
$ESListViewDefs[$module_name] = [
    'columns' => [
        'NAME' => [
            'name' => 'name',
            'label' => 'LBL_NAME',
            'default' => true,
            'enabled' => true,
            'link' => true,
        ],
        'CANDIDATE_NAME' => [
            'name' => 'candidate_name',
            'label' => 'LBL_CANDIDATES_TITLE',
            'enabled' => true,
            'module' => 'Candidates',
            'id' => 'CANDIDATE_ID',
            'link' => true,
            'sortable' => false,
            'default' => true,
        ],
        'status' => [
            'type' => 'enum',
            'name' => 'status',
            'label' => 'LBL_STATUS',
            'enabled' => true,
            'default' => true,
        ],
        'to_decision' => [
            'name' => 'to_decision',
            'label' => 'LBL_TO_DECISION',
            'enabled' => true,
            'default' => true,
        ],
        'net_amount' => [
            'name' => 'net_amount',
            'label' => 'LBL_NET_AMOUNT',
            'enabled' => true,
            'related_fields' => [
                'currency_id',
            ],
            'currency_format' => true,
            'default' => true,
        ],
        'gross_amount' => [
            'name' => 'gross_amount',
            'label' => 'LBL_GROSS_AMOUNT',
            'enabled' => true,
            'related_fields' => [
                'currency_id',
            ],
            'currency_format' => true,
            'default' => true,
        ],
        'dg_amount' => [
            'name' => 'dg_amount',
            'label' => 'LBL_DG_AMOUNT',
            'enabled' => true,
            'related_fields' => [
                'currency_id',
            ],
            'currency_format' => true,
            'default' => true,
        ],
        'scoring' => [
            'name' => 'scoring',
            'label' => 'SCORING',
            'enabled' => true,
            'default' => true,
        ],
        'assigned_user_name' => [
            'name' => 'assigned_user_name',
            'label' => 'LBL_ASSIGNED_TO_NAME',
            'default' => true,
            'enabled' => true,
            'link' => true,
        ],
        'EMPLOYEE_NAME' => [
            'width' => '9%',
            'label' => 'LBL_EMPLOYEE_NAME',
            'module' => 'Employees',
            'id' => 'EMPLOYEE_ID',
            'default' => true,
            'link' => true,
        ],
        'DATE_MODIFIED' => [
            'label' => 'LBL_DATE_MODIFIED',
            'enabled' => true,
            'default' => true,
            'name' => 'date_modified',
            'readonly' => true,
        ],
        'SOURCE' => [
            'name' => 'source',
            'label' => 'LBL_SOURCE',
            'enabled' => true,
            'default' => false,
        ],
        'START_DATE' => [
            'name' => 'start_date',
            'label' => 'LBL_START_DATE',
            'enabled' => true,
            'default' => false,
        ],
        'NOTICE' => [
            'name' => 'notice',
            'label' => 'LBL_NOTICE',
            'enabled' => true,
            'sortable' => false,
            'default' => false,
        ],
        'NOTICE_FINAL_EXPECTATIONS' => [
            'name' => 'notice_final_expectations',
            'label' => 'LBL_NOTICE_FINAL_EXPECTATIONS',
            'enabled' => true,
            'sortable' => false,
            'default' => false,
        ],
        'FINAL_EMPLOYMENT_FORM' => [
            'name' => 'final_employment_form',
            'label' => 'LBL_FINAL_EMPLOYMENT_FORM',
            'enabled' => true,
            'default' => false,
        ],
        'EMPLOYMENT_FORM' => [
            'name' => 'employment_form',
            'label' => 'LBL_EMPLOYMENT_FORM',
            'enabled' => true,
            'default' => false,
        ],
        'RECRUITMENT_NAME' => [
            'name' => 'recruitment_name',
            'label' => 'LBL_CANDIDATURES_RECRUITMENTS_FROM_RECRUITMENTS_TITLE',
            'enabled' => true,
            'id' => 'RECRUITMENT_ID',
            'link' => true,
            'sortable' => false,
            'default' => false,
            'module' => 'Recruitments',
        ],
        'RECRUITMENT_END_NAME' => [
            'name' => 'recruitment_end_name',
            'label' => 'LBL_CANDIDATURES_RECRUITMENTS_END_FROM_RECRUITMENTS_TITLE',
            'enabled' => true,
            'id' => 'RECRUITMENT_END_ID',
            'link' => true,
            'sortable' => false,
            'default' => false,
            'module' => 'Recruitments',
        ],
        'SALARY_NET' => [
            'name' => 'salary_net',
            'label' => 'LBL_SALARY_NET',
            'enabled' => true,
            'related_fields' => [
                'currency_id',
            ],
            'currency_format' => true,
            'default' => false,
        ],
        'TASK_GRADE' => [
            'name' => 'task_grade',
            'label' => 'LBL_TASK_GRADE',
            'enabled' => true,
            'default' => false,
        ],
        'REASON_FOR_REJECTION' => [
            'name' => 'reason_for_rejection',
            'label' => 'LBL_REASON_FOR_REJECTION',
            'enabled' => true,
            'default' => false,
        ],
    ],
    'search' => [
        'name' => [],
        'candidate_nae' => [],
        'status' => [],
        'to_decision' => [],
        'net_amount' => [],
        'gross_amount' => [],
        'dg_amount' => [],
        'scoring' => [],
        'employee_name' => [],
        'source' => [],
        'start_date' => [],
        'notice' => [],
        'final_employment_form' => [],
        'employment_form' => [],
        'recruitment_name' => [],
        'recruitment_end_name' => [],
        'salary_net' => [],
        'task_grade' => [],
        'assigned_user_name' => [],
        'date_entered' => [],
        'date_modified' => [],
        'created_by_name' => [],
        'modified_by_name' => [],
    ],
];
