<?php

require('lib/FastRoute/bootstrap.php');
require('lib/FastRoute/functions.php');

spl_autoload_register(function($class_name) {
   static $class_map = array(
      'Slim\\App' => '/Slim/App.php',
      'Slim\\CallableResolver' => '/Slim/CallableResolver.php',
      'Slim\\CallableResolverAwareTrait' => '/Slim/CallableResolverAwareTrait.php',
      'Slim\\Collection' => '/Slim/Collection.php',
      'Slim\\Container' => '/Slim/Container.php',
      'Slim\\DefaultServicesProvider' => '/Slim/DefaultServicesProvider.php',
      'Slim\\DeferredCallable' => '/Slim/DeferredCallable.php',
      'Slim\\MiddlewareAwareTrait' => '/Slim/MiddlewareAwareTrait.php',
      'Slim\\Routable' => '/Slim/Routable.php',
      'Slim\\Route' => '/Slim/Route.php',
      'Slim\\RouteGroup' => '/Slim/RouteGroup.php',
      'Slim\\Router' => '/Slim/Router.php',
      'Slim\\Exception\\ContainerException' => '/Slim/Exception/ContainerException.php',
      'Slim\\Exception\\ContainerValueNotFoundException' => '/Slim/Exception/ContainerValueNotFoundException.php',
      'Slim\\Exception\\InvalidMethodException' => '/Slim/Exception/InvalidMethodException.php',
      'Slim\\Exception\\MethodNotAllowedException' => '/Slim/Exception/MethodNotAllowedException.php',
      'Slim\\Exception\\NotFoundException' => '/Slim/Exception/NotFoundException.php',
      'Slim\\Exception\\SlimException' => '/Slim/Exception/SlimException.php',
      'Slim\\Handlers\\Strategies\\RequestResponse' => '/Slim/Handlers/Strategies/RequestResponse.php',
      'Slim\\Handlers\\Strategies\\RequestResponseArgs' => '/Slim/Handlers/Strategies/RequestResponseArgs.php',
      'Slim\\Handlers\\AbstractError' => '/Slim/Handlers/AbstractError.php',
      'Slim\\Handlers\\AbstractHandler' => '/Slim/Handlers/AbstractHandler.php',
      'Slim\\Handlers\\Error' => '/Slim/Handlers/Error.php',
      'Slim\\Handlers\\NotAllowed' => '/Slim/Handlers/NotAllowed.php',
      'Slim\\Handlers\\NotFound' => '/Slim/Handlers/NotFound.php',
      'Slim\\Handlers\\PhpError' => '/Slim/Handlers/PhpError.php',
      'Slim\\Http\\Body' => '/Slim/Http/Body.php',
      'Slim\\Http\\Cookies' => '/Slim/Http/Cookies.php',
      'Slim\\Http\\Environment' => '/Slim/Http/Environment.php',
      'Slim\\Http\\Headers' => '/Slim/Http/Headers.php',
      'Slim\\Http\\Message' => '/Slim/Http/Message.php',
      'Slim\\Http\\Request' => '/Slim/Http/Request.php',
      'Slim\\Http\\RequestBody' => '/Slim/Http/RequestBody.php',
      'Slim\\Http\\Response' => '/Slim/Http/Response.php',
      'Slim\\Http\\Stream' => '/Slim/Http/Stream.php',
      'Slim\\Http\\UploadedFile' => '/Slim/Http/UploadedFile.php',
      'Slim\\Http\\Uri' => '/Slim/Http/Uri.php',
      'Slim\\Interfaces\\Http\\CookiesInterface' => '/Slim/Interfaces/Http/CookiesInterface.php',
      'Slim\\Interfaces\\Http\\EnvironmentInterface' => '/Slim/Interfaces/Http/EnvironmentInterface.php',
      'Slim\\Interfaces\\Http\\HeadersInterface' => '/Slim/Interfaces/Http/HeadersInterface.php',
      'Slim\\Interfaces\\CallableResolverInterface' => '/Slim/Interfaces/CallableResolverInterface.php',
      'Slim\\Interfaces\\CollectionInterface' => '/Slim/Interfaces/CollectionInterface.php',
      'Slim\\Interfaces\\InvocationStrategyInterface' => '/Slim/Interfaces/InvocationStrategyInterface.php',
      'Slim\\Interfaces\\RouteGroupInterface' => '/Slim/Interfaces/RouteGroupInterface.php',
      'Slim\\Interfaces\\RouteInterface' => '/Slim/Interfaces/RouteInterface.php',
      'Slim\\Interfaces\\RouterInterface' => '/Slim/Interfaces/RouterInterface.php',
      'Pimple\\Exception\\ExpectedInvokableException' => '/lib/Pimple/Exception/ExpectedInvokableException.php',
      'Pimple\\Exception\\FrozenServiceException' => '/lib/Pimple/Exception/FrozenServiceException.php',
      'Pimple\\Exception\\InvalidServiceIdentifierException' => '/lib/Pimple/Exception/InvalidServiceIdentifierException.php',
      'Pimple\\Exception\\UnknownIdentifierException' => '/lib/Pimple/Exception/UnknownIdentifierException.php',
      'Pimple\\Psr11\\Container' => '/lib/Pimple/Psr11/Container.php',
      'Pimple\\Psr11\\ServiceLocator' => '/lib/Pimple/Psr11/ServiceLocator.php',
      'Pimple\\Container' => '/lib/Pimple/Container.php',
      'Pimple\\ServiceIterator' => '/lib/Pimple/ServiceIterator.php',
      'Pimple\\ServiceProviderInterface' => '/lib/Pimple/ServiceProviderInterface.php',
      'Psr\\Container\\ContainerExceptionInterface' => '/lib/Psr/container/ContainerExceptionInterface.php',
      'Psr\\Container\\ContainerInterface' => '/lib/Psr/container/ContainerInterface.php',
      'Psr\\Container\\NotFoundExceptionInterface' => '/lib/Psr/container/NotFoundExceptionInterface.php',
      'Psr\\Http\\Message\\MessageInterface' => '/lib/Psr/http-message/MessageInterface.php',
      'Psr\\Http\\Message\\RequestInterface' => '/lib/Psr/http-message/RequestInterface.php',
      'Psr\\Http\\Message\\ResponseInterface' => '/lib/Psr/http-message/ResponseInterface.php',
      'Psr\\Http\\Message\\ServerRequestInterface' => '/lib/Psr/http-message/ServerRequestInterface.php',
      'Psr\\Http\\Message\\StreamInterface' => '/lib/Psr/http-message/StreamInterface.php',
      'Psr\\Http\\Message\\UploadedFileInterface' => '/lib/Psr/http-message/UploadedFileInterface.php',
      'Psr\\Http\\Message\\UriInterface' => '/lib/Psr/http-message/UriInterface.php',
      'Interop\\Container\\ContainerInterface' => '/lib/container-interop/ContainerInterface.php',
      'Interop\\Container\\Exception\\ContainerException' => '/lib/container-interop/Exception/ContainerException.php',
      'Interop\\Container\\Exception\\NotFoundException' => '/lib/container-interop/Exception/NotFoundException.php',
      'FastRoute\\BadRouteException' => '/lib/FastRoute/BadRouteException.php',
      'FastRoute\\DataGenerator' => '/lib/FastRoute/DataGenerator.php',
      'FastRoute\\Dispatcher' => '/lib/FastRoute/Dispatcher.php',
      'FastRoute\\Route' => '/lib/FastRoute/Route.php',
      'FastRoute\\RouteCollector' => '/lib/FastRoute/RouteCollector.php',
      'FastRoute\\RouteParser' => '/lib/FastRoute/RouteParser.php',
      'FastRoute\\DataGenerator\\CharCountBased' => '/lib/FastRoute/DataGenerator/CharCountBased.php',
      'FastRoute\\DataGenerator\\GroupCountBased' => '/lib/FastRoute/DataGenerator/GroupCountBased.php',
      'FastRoute\\DataGenerator\\GroupPosBased' => '/lib/FastRoute/DataGenerator/GroupPosBased.php',
      'FastRoute\\DataGenerator\\MarkBased' => '/lib/FastRoute/DataGenerator/MarkBased.php',
      'FastRoute\\DataGenerator\\RegexBasedAbstract' => '/lib/FastRoute/DataGenerator/RegexBasedAbstract.php',
      'FastRoute\\Dispatcher\\CharCountBased' => '/lib/FastRoute/Dispatcher/CharCountBased.php',
      'FastRoute\\Dispatcher\\GroupCountBased' => '/lib/FastRoute/Dispatcher/GroupCountBased.php',
      'FastRoute\\Dispatcher\\GroupPosBased' => '/lib/FastRoute/Dispatcher/GroupPosBased.php',
      'FastRoute\\Dispatcher\\MarkBased' => '/lib/FastRoute/Dispatcher/MarkBased.php',
      'FastRoute\\Dispatcher\\RegexBasedAbstract' => '/lib/FastRoute/Dispatcher/RegexBasedAbstract.php',
      'FastRoute\\RouteParser\\Std' => '/lib/FastRoute/RouteParser/Std.php',
   );

   if ( !empty($class_map[$class_name]) ) {
      $path = __DIR__ . $class_map[$class_name];
      require($path);
   }
}, true);
